[//lasso
	define_tag(
		'relative',
		-namespace='date_',
		-req='in', -type='date', -copy,
		-opt='format', -type='string',
		-priority='replace',
		-description='Outputs the given date in relative format (yesterday/today/tomorrow).'
	);
		!local_defined('format') ? local('format' = '%D %h:%M %p');
	
		local(
			'rel' = string,
			'out' = string,
			'day' = @#in->dayofyear,
			'daysinyear' = (lp_date_leapyear ? 366 | 365),
			'today' = @date->dayofyear
		);
		
		local(
			'yesterday' = (#today - 1 == 0 ? #daysinyear | #today - 1),
			'tomorrow' = (#today + 1 > #daysinyear ? 1 | #today + 1)
		);
	
		select(true);
			case(#today == #day);
				#rel = 'Today';			
			case(#yesterday == #day);
				#rel = 'Yesterday';				
			case(#tomorrow == #day);
				#rel = 'Tomorrow';
			case(#day > #tomorrow && #day < #today + 7);
				#rel = 'This ' + #in->format('%A');
			case(#day >= #today + 7 && #day < #today + 14);
				#rel = 'Next ' + #in->format('%A');
			case;
				return(#in->format(#format)->lowercase&);
		/select;
		
		#out = (#rel + ' ' + #in->format('%h:%M %p')->lowercase&);
		return(#out);
	/define_tag;



	/* SVN: $Id: date_relative.inc 439 2007-06-08 00:46:13Z Jason Huck $ */
]
